<?php 
namespace App\Controllers;

use Mpdf\Mpdf;
use Dompdf\Dompdf;

use Tiyyick\Router\Controller;
use Tiyyick\Http\Request;

use App\Models\Sale;
use App\Models\Category;
use App\Models\Purchase;
use App\Models\Supplier;
use App\Models\Customer;
use App\Models\Product;
use App\Models\Staff;
use App\Models\Stock;
use App\Models\Store;
use App\Models\Payment;
use App\Models\Invoice;
use App\Models\Inventory;
use App\Models\PaymentMode;
use App\Models\Company;

/**
 * 
 */
class PurchaseController extends Controller
{
	// PURCHASE
	public function purchase()
	{
		$data['purchases'] = Purchase::query()->all();
		$data['products']  = Product::query()->all();
		$data['suppliers'] = Supplier::query()->all();

		return render('admin/purchase/purchase', $data);
	}

	public function createPurchase(Request $request)
	{
		$valid = validate($request);
		
		if ($valid->isValid()) {
			if (! empty($request->input('rows'))) {
				foreach ($request->input('rows') as $row) {
					$purchase = new Purchase($row);
					$purchase->supplier = $row['supplier'] == "" ? null : $row['supplier'];
					$purchase->save();
				}
			}
			
		    return json_response(['ok' => true, 'msg' => "Product purchase created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}

	}

	public function purchaseEdit($id)
	{
		$data['purchase'] = Purchase::query()->get($id);
		$data['products'] = Product::query()->all();
		$data['suppliers'] = Supplier::query()->all();

		return render('admin/purchase/purchase-edit', $data);
	}

	public function updatePurchase(Request $request, $id)
	{
		$valid = validate($request, [
			'product'  => ['required' => true],
			'quantity' => ['required' => true],
		]);

		if ($valid->isValid()) {
			$purchase = Purchase::query()->filter(['id' => $id])->one(); 
			$purchase->update($request->body());
			$purchase->supplier = $request->supplier == "" ? null : $request->supplier;

			$purchase->save();

		    return json_response(['ok' => true, 'url' => route('purchase.index'), 'msg' => "Product purchase updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deletePurchase(Request $request, $id)
	{
		$form = validate($request);
		if ($form->isValid()) {
			Purchase::query()->filter(['id' => $id])->delete();
			return json_response(['ok' => true, 'msg' => "Product purchase deleted successfully",]);
		} else {
			return json_response(['token_error' => 'Tampered token or no token']);
		}
	}

	// STOCKS
	public function stock()
	{
		$data['stocks'] = Stock::query()->all();
		$data['stores'] = Store::query()->all();
		$data['products']  = Product::query()->all();
		$data['purchases']  = Purchase::query()->all();

		return render('admin/purchase/stock', $data);
	}

	public function createStock(Request $request)
	{
		$valid = validate($request);
		filelog($request->input('rows'));
		if ($valid->isValid()) {
			if (! empty($request->input('rows'))) {
				foreach ($request->input('rows') as $row) {
					Product::query()->filter(['id' => $row['product']])->update(['price' => $row['price']]);
					$inventory = Inventory::query()->filter(['store' => $row['store'], 'and', 'product' => $row['product']])->one();
					$inventory->quantity = (int) $inventory->quantity + (int) $row['quantity'];
					$inventory->save();
					$stock = new Stock($row);
					$stock->inventory = $inventory;
					$stock->purchase = $row['purchase'] == "" ? null : $row['purchase'];
					$stock->save();
				}
			}
			
		    return json_response(['ok' => true, 'msg' => "Product stock created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}

	}

	public function stockEdit($id)
	{
		$data['stock'] = Stock::query()->get($id);
		$data['purchases'] = Purchase::query()->all();
		$data['products'] = Product::query()->all();
		$data['stores'] = Store::query()->all();

		return render('admin/purchase/stock-edit', $data);
	}

	public function updateStock(Request $request, $id)
	{
		$valid = validate($request, [
			'quantity' => ['required' => true],
		]);

		if ($valid->isValid()) {
			$stock = Stock::query()->filter(['id' => $id])->one(); 
			$oldQty = (int) $stock->quantity;
			$newQty = (int) $request->quantity;
			$stock->update($request->body());

			if ($oldQty != $newQty) {
				$stock->quantity = $oldQty > $newQty ? $oldQty - ($oldQty - $newQty) : $oldQty + ($newQty - $oldQty);
				/*if ($oldQty > $newQty) {
					$stock->quantity = $oldQty - ($oldQty - $newQty);
				} else {
					$stock->quantity = $oldQty + ($newQty - $oldQty);
				}*/
			}

			if ($request->hasField('purchase')) {
				$stock->purchase = $request->purchase == "" ? null : $request->purchase;
			}
			
			$stock->save();

		    return json_response(['ok' => true, 'url' => route('stock.index'), 'msg' => "Product stock updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deleteStock(Request $request, $id)
	{
		$form = validate($request);
		if ($form->isValid()) {
			Stock::query()->filter(['id' => $id])->delete();
			return json_response(['ok' => true, 'msg' => "Product stock deleted successfully",]);
		} else {
			return json_response(['token_error' => 'Tampered token or no token']);
		}
	}

	// SALES
	public function sale()
	{
		$data['sales'] = Sale::query()->all();
		// $data['invoices']  = Invoice::query()->all();

		return render('admin/purchase/sale-all', $data);
	}

	public function saleAdd()
	{
		$data['payment_modes'] = PaymentMode::query()->all();
		$data['customers'] = Customer::query()->all();
		$data['products'] = Product::query()->all();
		$data['stores'] = Store::query()->all();

		return render('admin/purchase/sale-add', $data);
	}

	public function createSale(Request $request)
	{
		$valid = validate($request);
		if ($valid->isValid()) {
			if (! empty($request->input('rows'))) {
				$invoice = new Invoice([
					'issuer' => auth()->user()->id,
					'customer' => $request->input('customer'),
					'date' => $request->input('date'),
					'paid' => $request->input('paid'),
					'amount' => $request->input('amount'),
					'balance' => $request->input('balance'),
					'discount' => $request->input('discount'),
					'bill_code' => $request->input('bill_code')
				]);
				$invoice = $invoice->save();
				foreach ($request->input('rows') as $row) {
					$inventory = Inventory::query()->filter(['product' => $row['product'], 'and', 'store' => $row['store']])->one();
					$inventory->quantity = (int) $inventory->quantity - (int) $row['quantity'];
					// $inventory->update(['quantity' => (int) $inventory->quantity - (int) $row['quantity']]);
					$inventory->save();

					$sale = new Sale($row);
					$sale->inventory = $inventory->id;
					$sale->invoice = $invoice->id;
					$sale->save();
				}
				Payment::query()->create([
					'invoice' => $invoice->id,
					'date' => $request->input('date'),
					'amount' => $request->input('paid'),
					'balance' => $request->input('balance'),
					'payment_mode' => $request->input('payment_mode')
				]);
		    	return json_response(['ok' => true, 'url' => route('invoice.index'), 'msg' => "Product sale created successfully"]);
			}
			
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function saleEdit($id)
	{
		$data['sale'] = Sale::query()->get($id);
		// $data['invoices'] = Invoice::query()->all();
		$data['products'] = Product::query()->all();
		$data['stores'] = Store::query()->all();

		return render('admin/purchase/sale-edit', $data);
	}

	public function updateSale(Request $request, $id)
	{
		$valid = validate($request, [
			'store'    => ['required' => true],
			'product'  => ['required' => true],
			'quantity' => ['required' => true],
		]);

		if ($valid->isValid()) {
			$sale = Sale::query()->filter(['id' => $id])->one(); 
			$sale->update($request->body());
			if ($request->hasField('purchase')) {
				$sale->purchase = $request->purchase == "" ? null : $request->purchase;
			}
			
			$sale->save();

		    return json_response(['ok' => true, 'url' => route('sale.index'), 'msg' => "Product sale updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deleteSale(Request $request, $id)
	{
		$form = validate($request);
		if ($form->isValid()) {
			Sale::query()->filter(['id' => $id])->delete();
			return json_response(['ok' => true, 'msg' => "Product sale deleted successfully",]);
		} else {
			return json_response(['token_error' => 'Tampered token or no token']);
		}
	}

	// STOCKS
	public function invoice()
	{
		$data['invoices'] = Invoice::query()->order_by('id:DESC')->all();
		$data['payment_modes'] = PaymentMode::query()->all();
		/*$data['stores'] = Store::query()->all();
		$data['products']  = Product::query()->all();
		$data['purchases']  = Purchase::query()->all();*/

		return render('admin/purchase/invoice', $data);
	}

	public function invoiceDetails(Request $request, $invoice_no, $id)
	{
		$mpdf = new Mpdf(['mode' => 'utf-8', 'format' => 'A', 'margin_left' => 10, 'margin_right' => 10]);
		$data['invoice'] = Invoice::query()->filter(['bill_code' => $invoice_no, 'or', 'id' => $id])->one();
		// $data['payment_modes'] = PaymentMode::query()->all();
		$data['general_setting'] = Company::query()->get(1);
		// $data['products'] = Product::query()->all();
		// $data['stores'] = Store::query()->all();
		$html = render_string('admin/purchase/invoice-pdf', $data);
		$mpdf->WriteHTML($html);
		$mpdf->Output();

		// return render('admin/purchase/invoice-details', $data);
	}

	public function deleteInvoice(Request $request, $id)
	{
		$form = validate($request);
		if ($form->isValid()) {
			Invoice::query()->filter(['id' => $id])->delete();
			return json_response(['ok' => true, 'msg' => "Invoice deleted successfully",]);
		} else {
			return json_response(['token_error' => 'Tampered token or no token']);
		}
	}

	// Payment
	public function payment()
	{
		$payments = Payment::query()->order_by('id|DESC')->all();

		return render('admin/purchase/payment', ['payments' => $payments]);
	}

	public function createPayment(Request $request)
	{
		$valid = validate($request, [
			'date' => ['required' => true],
			'amount' => ['required' => true],
			'payment_mode' => ['required' => true],
		]);

		if ($valid->isValid()) {
			$invoice = Invoice::query()->filter(['id' => $request->invoice])->one();
			$invoice->paid = (int) $invoice->paid + (int) $request->amount;
			$invoice->balance = (int) $invoice->amount - (int) $invoice->paid;
			$invoice->save();
			$payment = new Payment($request->body());
			$payment->balance = $invoice->balance;
			$payment->save();

		    return json_response(['ok' => true, 'msg' => "Payment created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function updatePayment(Request $request, $id)
	{
		$valid = validate($request, [
			'date' => ['required' => true],
			'amount' => ['required' => true],
			'payment_mode' => ['required' => true],
		]);

		if ($valid->isValid()) {
			Payment::query()->filter(['id' => $id])->update($request->body()); 

		    return json_response(['ok' => true, 'msg' => "Payment updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors(), 'update' => true]);
		}
	}

	public function deletePayment(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			Payment::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Payment deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function invoicePdf()
	{
		$mpdf = new Mpdf(['mode' => 'utf-8', 'format' => [100, 200]]);
		$html = '<div>
			<style type="text/css">
				table, th, td {
				  	border: 1px solid black;
				  	border-collapse: collapse;
				}
			</style>
			<h4>Double Point</h4>
			<div><b>Address:</b> 10 Ikoku Str Diobu</div>
			<div><b>Phone:</b> 090887766554</div>
			<div><b>Email:</b> sales@dpm.com.ng</div><br />
			<table>
				<tr>
					<th>S/N</th>
					<th>Item</th>
					<th>Rate</th>
					<th>Quantity</th>
					<th>Amount</th>
				</tr>
				<tr>
					<td>1</td>
					<td>Brake pad</td>
					<td>200</td>
					<td>2</td>
					<td>400</td>
				</tr>
				<tr>
					<td>2</td>
					<td>Car horn</td>
					<td>200</td>
					<td>2</td>
					<td>400</td>
				</tr>
				<tr>
					<td>3</td>
					<td>Engine plug</td>
					<td>200</td>
					<td>2</td>
					<td>400</td>
				</tr>
				<tr>
					<td>4</td>
					<td>Car leg</td>
					<td>200</td>
					<td>2</td>
					<td>400</td>
				</tr>
				<tr>
					<th colspan="4">Total</th>
					<td>400</td>
				</tr>
			</table>
		</div>';
		$mpdf->WriteHTML($html);
		$mpdf->Output();

	}

}
