<?php 
namespace App\Controllers;

use Tiyyick\Router\Controller;
use Tiyyick\Http\Request;

use App\Models\Product;
use App\Models\Category;
use App\Models\Brand;
use App\Models\Unit;
use App\Models\ProductType;
use App\Models\Supplier;
use App\Models\Staff;
use App\Models\Inventory;

/**
 * 
 */
class ProductController extends Controller
{
	// CATEGORY
	public function category()
	{
		$categorys = Category::query()->order_by('id|DESC')->all();

		return render('admin/product/category', ['categorys' => $categorys]);
	}

	public function createCategory(Request $request)
	{
		$valid = validate($request, [
			'name' => ['required' => true, 'unique' => Category::class],
		]);

		if ($valid->isValid()) {
			Category::query()->create($request->body());

		    return json_response(['ok' => true, 'msg' => "Category created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function updateCategory(Request $request, $id)
	{
		$valid = validate($request, [
			'name' => ['required' => true, 'unique' => [Category::class, $id]],
		]);

		if ($valid->isValid()) {
			Category::query()->filter(['id' => $id])->update($request->body()); 

		    return json_response(['ok' => true, 'msg' => "Category updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors(), 'update' => true]);
		}
	}

	public function deleteCategory(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			Category::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Category deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	// PRODUCT
	public function product()
	{
		$data['products'] = Product::query()->order_by('id|DESC')->all();
		$data['categorys'] = Category::query()->all();
		$data['brands'] = Brand::query()->all();
		$data['units'] = Unit::query()->all();
		$data['types'] = ProductType::query()->all();

		return render('admin/product/product', $data);
	}

	public function selectProduct(Request $request)
	{
		$category = Category::query()->get($request->productcate_id);

		return json_response(prettify($category->products->all()));
	}

	public function productData(Request $request)
	{
		$inventory = Inventory::query()->filter(['product' => $request->p_id, 'and', 'store' => $request->s_id])->one();
		$data = ['ok' => true, 'quantity' => $inventory->quantity, 'price' => $inventory->product->price];

		return json_response($data);
	}

	public function createProduct(Request $request)
	{
		$valid = validate($request, [
			'name'     => ['required' => true],
			'category' => ['required' => true],
		]);

		if ($valid->isValid()) {
			$product = new Product($request->body());

			if ($request->hasFile('image')) {
				$file = $request->getFile('image');
				$product->image = $file->store('product', bin2hex(random_bytes(10)) . '.png');
			}

			$product->type = $request->type == "" ? null : $request->type;
			$product->unit = $request->unit == "" ? null : $request->unit;
			$product->brand = $request->brand == "" ? null : $request->brand;

			$product->save();

		    return json_response(['ok' => true, 'msg' => "Product created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function productEdit($id)
	{
		$data['product'] = Product::query()->get($id);
		$data['categorys'] = Category::query()->all();
		$data['brands'] = Brand::query()->all();
		$data['units'] = Unit::query()->all();
		$data['types'] = ProductType::query()->all();

		return render('admin/product/product-edit', $data);
	}

	public function updateProduct(Request $request, $id)
	{
		$valid = validate($request, [
			'name' 	   => ['required' => true],
			'category' => ['required' => true],
		]);

		if ($valid->isValid()) {
			$product = Product::query()->filter(['id' => $id])->one(); 
			$product->update($request->body());

			if ($request->hasFile('image')) {
				if (file_exists(storage_path("product/$product->image"))) {
	                unlink(storage_path("product/$product->image"));
	            } 
				
				$file = $request->getFile('image');
				$product->image = $file->store('product',  bin2hex(random_bytes(10)). '.jpg');
			}

			$product->type = $request->type == "" ? null : $request->type;
			$product->unit = $request->unit == "" ? null : $request->unit;
			$product->brand = $request->brand == "" ? null : $request->brand;

			$product->save();

		    return json_response(['ok' => true, 'url' => route('product.index'), 'msg' => "Product updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deleteProduct(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			Product::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Product deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	// PRODUCT TYPE
	public function productType()
	{
		$product_types = ProductType::query()->order_by('id|DESC')->all();

		return render('admin/product/type', ['product_types' => $product_types]);
	}

	public function createProductType(Request $request)
	{
		$valid = validate($request, [
			'type' => ['required' => true, 'unique' => ProductType::class],
		]);

		if ($valid->isValid()) {
			ProductType::query()->create($request->body());

		    return json_response(['ok' => true, 'msg' => "Product type created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function updateProductType(Request $request, $id)
	{
		$valid = validate($request, [
			'type' => ['required' => true, 'unique' => [ProductType::class, $id]],
		]);

		if ($valid->isValid()) {
			ProductType::query()->filter(['id' => $id])->update($request->body()); 

		    return json_response(['ok' => true, 'msg' => "Product type updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors(), 'update' => true]);
		}
	}

	public function deleteProductType(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			ProductType::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Product type deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	// Brand
	public function brand()
	{
		$brands = Brand::query()->order_by('id|DESC')->all();

		return render('admin/product/brand', ['brands' => $brands]);
	}

	public function createBrand(Request $request)
	{
		$valid = validate($request, [
			'name' => ['required' => true, 'unique' => Brand::class],
		]);

		if ($valid->isValid()) {
			$brand = new Brand($request->body());

			if ($request->hasFile('logo')) {
				$file = $request->getFile('logo');
				$brand->logo = $file->store('brand', bin2hex(random_bytes(10)) . '.png');
			}

			$brand->save();

		    return json_response(['ok' => true, 'msg' => "Brand created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function updateBrand(Request $request, $id)
	{
		$valid = validate($request, [
			'name' => ['required' => true, 'unique' => [Brand::class, $id]],
		]);

		if ($valid->isValid()) {
			$brand = Brand::query()->filter(['id' => $id])->one(); 
			$brand->update($request->body());

			if ($request->hasFile('logo')) {
				if (file_exists(storage_path("brand/$brand->logo"))) {
	                unlink(storage_path("brand/$brand->logo"));
	            } 
				
				$file = $request->getFile('logo');
				$brand->logo = $file->store('brand',  bin2hex(random_bytes(10)). '.jpg');
			}

			$brand->save();

		    return json_response(['ok' => true, 'msg' => "Brand updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors(), 'update' => true]);
		}
	}

	public function deleteBrand(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			Brand::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Brand deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	// Unit
	public function unit()
	{
		$units = Unit::query()->order_by('id|DESC')->all();

		return render('admin/product/unit', ['units' => $units]);
	}

	public function createUnit(Request $request)
	{
		$valid = validate($request, [
			'name' => ['required' => true, 'unique' => Unit::class],
			'code' => ['required' => true],
		]);

		if ($valid->isValid()) {
			Unit::query()->create($request->body());

		    return json_response(['ok' => true, 'msg' => "Unit created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function updateUnit(Request $request, $id)
	{
		$valid = validate($request, [
			'name' => ['required' => true, 'unique' => [Unit::class, $id]],
			'code' => ['required' => true],
		]);

		if ($valid->isValid()) {
			Unit::query()->filter(['id' => $id])->update($request->body()); 

		    return json_response(['ok' => true, 'msg' => "Unit updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors(), 'update' => true]);
		}
	}

	public function deleteUnit(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			Unit::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Unit deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

}
