<?php 
namespace App\Controllers;

use Tiyyick\Router\Controller;
use Tiyyick\Http\Request;
use App\Models\Material;
use App\Models\MaterialType;
use App\Models\Klass;
use App\Models\Subject;
use App\Models\Staff;

/**
 * 
 */
class MaterialController extends Controller
{

	public function materialType()
	{
		$material_types = MaterialType::query()->order_by('id|DESC')->all();

		return render('admin/material/material-type', ['material_types' => $material_types]);
	}

	public function createMaterialType(Request $request)
	{
		$valid = validate($request, [
			'type' => ['required' => true, 'unique' => MaterialType::class],
		]);

		if ($valid->isValid()) {
			MaterialType::query()->create($request->body());

		    return json_response(['ok' => true, 'msg' => "Material type created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function updateMaterialType(Request $request, $id)
	{
		$valid = validate($request, [
			'type' => ['required' => true, 'unique' => [MaterialType::class, $id]],
		]);

		if ($valid->isValid()) {
			$mtype = MaterialType::query()->filter(['id' => $id])->one(); 
			$mtype->type = $request->type;
			$mtype->remark = $request->remark;
			$mtype->save();

		    return json_response(['ok' => true, 'msg' => "Material type updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deleteMaterialType(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			MaterialType::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Material type deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}
	
	// MATERIAL ACTIONS
	public function material()
	{
		$data['materials'] = Material::query()->order_by('id|DESC')->all();
		$data['material_types'] = MaterialType::query()->all();

		return render('admin/material/material', $data);
	}

	public function selectMaterial(Request $request)
	{
		$mtype = MaterialType::query()->get($request->mtype_id);

		return json_response(prettify($mtype->materials->all()));
	}

	public function createMaterial(Request $request)
	{
		$valid = validate($request, [
			'title' => ['required' => true],
			'type' => ['required' => true],
		]);

		if ($valid->isValid()) {
			$material = new Material($request->body());

			if ($request->hasFile('document')) {
				$file = $request->getFile('document');
				$material->document = $file->store('material', bin2hex(random_bytes(10)) . '.jpg');
			}

			$material->save();

		    return json_response(['ok' => true, 'msg' => "Material created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors(), 'old' => $request->body()]);
		}
	}

	public function materialEdit($id)
	{
		$data['material'] = Material::query()->get($id);
		$data['material_types'] = MaterialType::query()->all();

		return render('admin/material/material-edit', $data);
	}

	public function updateMaterial(Request $request, $id)
	{
		$valid = validate($request, [
			'title' => ['required' => true],
			'type' => ['required' => true],
			'klass' => ['required' => true],
			'subject' => ['required' => true],
		]);

		if ($valid->isValid()) {
			$material = Material::query()->filter(['id' => $id])->one(); 
			$material->update($request->body());

			if ($request->hasFile('document')) {
				if (file_exists(storage_path("material/$material->document"))) {
	                unlink(storage_path("material/$material->document"));
	            } 
				
				$file = $request->getFile('document');
				$material->document = $file->store('material',  bin2hex(random_bytes(10)). '.png');
			}

			$material->save();

		    return json_response(['ok' => true, 'url' => route('material.index'), 'msg' => "Material updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deleteMaterial(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			Material::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Material deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors(), 'old' => $request->body()]);
		}
	}

}
