<?php 
namespace App\Controllers;

use Tiyyick\Router\Controller;
use Tiyyick\Http\Request;

use App\Models\Product;
use App\Models\Category;
use App\Models\Sale;
use App\Models\Stock;
use App\Models\Store;
use App\Models\Supplier;
use App\Models\Staff;
use App\Models\Customer;

/**
 * 
 */
class InventoryController extends Controller
{
	// STORE
	public function store()
	{
		$data['stores'] = Store::query()->order_by('id|DESC')->all();
		$data['managers'] = Staff::query()->all();

		return render('admin/inventory/store', $data);
	}

	public function createStore(Request $request)
	{
		$valid = validate($request, [
			'name'     => ['required' => true],
		]);

		if ($valid->isValid()) {
			$store = new Store($request->body());
			$store->manager = empty($request->manager) ? null : $request->manager;
			$store->save();

		    return json_response(['ok' => true, 'msg' => "Store created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function storeEdit($id)
	{
		$data['store'] = Store::query()->get($id);
		$data['managers'] = Staff::query()->all();

		return render('admin/inventory/store-edit', $data);
	}

	public function updateStore(Request $request, $id)
	{
		$valid = validate($request, [
			'name' 	   => ['required' => true],
		]);

		if ($valid->isValid()) {
			Store::query()->filter(['id' => $id])->update($request->body()); 

		    return json_response(['ok' => true, 'url' => route('store.index'), 'msg' => "Store updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deleteStore(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			Store::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Store deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	// SUPPLIER
	public function supplier()
	{
		$suppliers = Supplier::query()->order_by('id|DESC')->all();

		return render('admin/inventory/supplier', ['suppliers' => $suppliers,]);
	}

	public function createSupplier(Request $request)
	{
		$valid = validate($request, [
			'name'     => ['required' => true],
			'phone'     => ['required' => true],
		]);

		if ($valid->isValid()) {
			Supplier::query()->create($request->body());

		    return json_response(['ok' => true, 'msg' => "Supplier created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function supplierEdit($id)
	{
		$supplier = Supplier::query()->get($id);

		return render('admin/inventory/supplier-edit', ['supplier' => $supplier,]);
	}

	public function updateSupplier(Request $request, $id)
	{
		$valid = validate($request, [
			'name' 	   => ['required' => true],
			'phone'     => ['required' => true],
		]);

		if ($valid->isValid()) {
			Supplier::query()->filter(['id' => $id])->update($request->body()); 

		    return json_response(['ok' => true, 'url' => route('supplier.index'), 'msg' => "Supplier updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deleteSupplier(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			Supplier::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Supplier deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	// STOCK
	public function stock()
	{
		$data['stocks']    = Stock::query()->all();
		$data['stores']    = Store::query()->all();
		$data['purchases'] = Purchase::query()->all();
		$data['categorys'] = Category::query()->all();
		$data['products']  = Product::query()->all();

		return render('admin/inventory/stock', $data);
	}

	public function createStock(Request $request)
	{
		$valid = validate($request, [
			'store'    => ['required' => true],
			'product'  => ['required' => true],
			'quantity' => ['required' => true],
		]);

		if ($valid->isValid()) {
			Stock::query()->create($request->body());

		    return json_response(['ok' => true, 'msg' => "Stock created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function stockEdit($id)
	{
		$data['stock'] 	   = Stock::query()->get($id);
		$data['stores']    = Store::query()->all();
		$data['purchases'] = Purchase::query()->all();
		$data['categorys'] = Category::query()->all();
		$data['products']  = Product::query()->all();

		return render('admin/inventory/stock-edit', $data);
	}

	public function updateStock(Request $request, $id)
	{
		$valid = validate($request, [
			'store'    => ['required' => true],
			'product'  => ['required' => true],
			'quantity' => ['required' => true],
		]);

		if ($valid->isValid()) {
			Stock::query()->filter(['id' => $id])->update($request->body()); 

		    return json_response(['ok' => true, 'url' => route('stock.index'), 'msg' => "Stock updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deleteStock(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			Stock::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Stock deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	// Sale
	public function sale()
	{
		$data['sales'] = Sale::query()->order_by('id|DESC')->all();
		$data['categorys'] = Category::query()->all();
		$data['products'] = Product::query()->all();
		$data['users'] = Staff::query()->all();

		return render('admin/inventory/sale', $data);
	}

	public function selectSale(Request $request)
	{
		$category = Category::query()->get($request->salecate_id);

		return json_response(prettify($category->sales->all()));
	}

	public function createSale(Request $request)
	{
		$valid = validate($request, [
			'store'    => ['required' => true],
			'product'  => ['required' => true],
			'quantity' => ['required' => true],
		]);

		if ($valid->isValid()) {
			$sale = new Sale($request->body());
			$sale->saled_by = auth_user()->id;
			$sale->save();

		    return json_response(['ok' => true, 'msg' => "Sale created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function saleEdit($id)
	{
		$data['sale'] = Sale::query()->get($id);
		$data['categorys'] = Category::query()->all();
		$data['products'] = Product::query()->all();
		$data['users'] = Staff::query()->all();

		return render('admin/inventory/sale-edit', $data);
	}

	public function updateSale(Request $request, $id)
	{
		$valid = validate($request, [
			'store'    => ['required' => true],
			'product'  => ['required' => true],
			'quantity' => ['required' => true],
		]);

		if ($valid->isValid()) {
			Sale::query()->filter(['id' => $id])->update($request->body()); 

		    return json_response(['ok' => true, 'url' => route('sale.index'), 'msg' => "Sale updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deleteSale(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			Sale::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Sale deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	// CUSTOMER
	public function customer()
	{
		$customers = Customer::query()->order_by('id|DESC')->all();

		return render('admin/inventory/customer', ['customers' => $customers,]);
	}

	public function createCustomer(Request $request)
	{
		$valid = validate($request, [
			'name'     => ['required' => true],
		]);

		if ($valid->isValid()) {
			$customer = new Customer($request->body());
			$customer = $customer->save();

		    return json_response(['ok' => true, 'customerId' => $customer->id, 'customerName' => $customer->name, 'msg' => "Customer created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function customerEdit($id)
	{
		$customer = Customer::query()->get($id);

		return render('admin/inventory/customer-edit', ['customer' => $customer,]);
	}

	public function updateCustomer(Request $request, $id)
	{
		$valid = validate($request, [
			'name' 	   => ['required' => true],
		]);

		if ($valid->isValid()) {
			Customer::query()->filter(['id' => $id])->update($request->body()); 

		    return json_response(['ok' => true, 'url' => route('customer.index'), 'msg' => "Customer updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deleteCustomer(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			Customer::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Customer deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

}
