<?php 
namespace App\Controllers;

use Tiyyick\Router\Controller;
use Tiyyick\Http\Request;

use App\Models\Event;
use App\Models\Notice;
use App\Models\Holiday;
use App\Models\EventType;
use App\Models\EventInvitee;
use App\Models\NoticeAudience;

/**
 * 
 */
class InformationController extends Controller
{
	// NOTICE
	public function notice()
	{
		$notices = Notice::query()->order_by('id|DESC')->all();

		return render('admin/information/notice', ['notices' => $notices]);
	}

	public function createNotice(Request $request)
	{
		$valid = validate($request, [
			'title' => ['required' => true],
		]);

		if ($valid->isValid()) {
			Notice::query()->create($request->body());

		    return json_response(['ok' => true, 'msg' => "Notice created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function updateNotice(Request $request, $id)
	{
		$valid = validate($request, [
			'title' => ['required' => true],
		]);

		if ($valid->isValid()) {
			$notice = Notice::query()->filter(['id' => $id])->one(); 
			$notice->title   = $request->title;
			$notice->message = $request->message;
			$notice->date 	 = $request->date;
			$notice->time 	 = $request->time;
			$notice->save();

		    return json_response(['ok' => true, 'msg' => "Notice updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deleteNotice(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			Notice::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Notice deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	// HOLIDAY
	public function holiday()
	{
		$holidays = Holiday::query()->order_by('id|DESC')->all();

		return render('admin/information/holiday', ['holidays' => $holidays]);
	}

	public function createHoliday(Request $request)
	{
		$valid = validate($request, [
			'title' => ['required' => true],
		]);

		if ($valid->isValid()) {
			Holiday::query()->create($request->body());

		    return json_response(['ok' => true, 'msg' => "Holiday created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function updateHoliday(Request $request, $id)
	{
		$valid = validate($request, [
			'title' => ['required' => true],
		]);

		if ($valid->isValid()) {
			$holiday = Holiday::query()->filter(['id' => $id])->one(); 
			$holiday->title 	  = $request->title;
			$holiday->start_date  = $request->start_date;
			$holiday->close_date  = $request->close_date;
			$holiday->description = $request->description;
			$holiday->save();

		    return json_response(['ok' => true, 'msg' => "Holiday updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deleteHoliday(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			Holiday::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Holiday deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	// EventType
	public function eventType()
	{
		$eventtypes = EventType::query()->order_by('id|DESC')->all();

		return render('admin/information/event-type', ['eventtypes' => $eventtypes]);
	}

	public function createEventType(Request $request)
	{
		$valid = validate($request, [
			'kind' => ['required' => true, 'unique' => EventType::class],
		]);

		if ($valid->isValid()) {
			EventType::query()->create($request->body());

		    return json_response(['ok' => true, 'msg' => "Event type created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function updateEventType(Request $request, $id)
	{
		$valid = validate($request, [
			'kind' => ['required' => true, 'unique' => [EventType::class, $id]],
		]);

		if ($valid->isValid()) {
			$eventType = EventType::query()->filter(['id' => $id])->one(); 
			$eventType->kind = $request->kind;
			$eventType->save();

		    return json_response(['ok' => true, 'msg' => "Event type updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deleteEventType(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			EventType::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Event type deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	// EVENT
	public function event()
	{
		$events = Event::query()->order_by('id|DESC')->all();
		$types = EventType::query()->all();

		return render('admin/information/event', ['events' => $events, 'types' => $types]);
	}

	public function selectEvent(Request $request)
	{
		$type = EventType::query()->get($request->type_id);

		return json_response(prettify($type->events->all()));
	}

	public function createEvent(Request $request)
	{
		$valid = validate($request, [
			'title' => ['required' => true],
			'type' => ['required' => true],
		]);

		if ($valid->isValid()) {
			$event = new Event();
			$event->title    	= $request->title;
			$event->type    	= $request->type;
			$event->venue    	= $request->venue;
			$event->start_date 	= $request->start_date;
			$event->close_date 	= $request->close_date;
			$event->description = $request->description;

			if ($request->hasFile('image')) {
				$file = $request->getFile('image');
				$event->image = $file->store('event', bin2hex(random_bytes(10)) . '.jpg');
			}

			$event->save();

		    return json_response(['ok' => true, 'msg' => "Event created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function eventEdit($id)
	{
		$event = Event::query()->get($id);
		$types = EventType::query()->all();

		return render('admin/information/event-edit', ['event' => $event, 'types' => $types]);
	}

	public function updateEvent(Request $request, $id)
	{
		$valid = validate($request, [
			'title' => ['required' => true],
			'type' => ['required' => true],
		]);

		if ($valid->isValid()) {
			$event = Event::query()->filter(['id' => $id])->one(); 
			$event->title    	= $request->title;
			$event->type    	= $request->type;
			$event->venue    	= $request->venue;
			$event->start_date 	= $request->start_date;
			$event->close_date 	= $request->close_date;
			$event->description = $request->description;

			if ($request->hasFile('image')) {
				if (file_exists(storage_path("event/$event->image"))) {
	                unlink(storage_path("event/$event->image"));
	            } 
				
				$file = $request->getFile('image');
				$event->image = $file->store('event',  bin2hex(random_bytes(10)). '.jpg');
			}

			$event->save();

		    return json_response(['ok' => true, 'url' => route('event.index'), 'msg' => "Event updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deleteEvent(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			Event::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Event deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

}
