<?php 
namespace App\Controllers;

use Tiyyick\Router\Controller;
use App\Helpers\FPDF;
use App\Models\Company;

/**
 * 
 */
class FileController extends Controller
{
	public function staff()
	{
		render_file('staff');
	}

	public function material()
	{
		render_file('material');
	}

	public function event()
	{
		render_file('event');
	}

	public function product()
	{
		render_file('product');
	}

	public function income()
	{
		render_file('income');
	}

	public function expense()
	{
		render_file('expense');
	}

	public function brand()
	{
		render_file('brand');
	}

	public function leave()
	{
		render_file('leave');
	}

	public function staffDocument()
	{
		download('staff-documents');
	}

	public function company()
	{
		render_file('company');
	}

	public function materialPDF()
	{
		$company = Company::query()->get(1);
		$pdf = new FPDF("P", "mm", [100, 400]);

		$pdf->AddPage();
		// $pdf->Image('img/admin-avatar.png', 10, 10, 80, 55);

		$pdf->SetFont("Arial", "B", 16);
		$pdf->Cell(80, 8, $company->name, 1, 1, "C");

		$pdf->SetFont("Arial", "B", 10);
		$pdf->Cell(80, 5, "Address: $company->address", 0, 1, "C");
		$pdf->Cell(80, 5, "Phone Number: $company->phone", 0, 1, "C");
		$pdf->Cell(80, 5, "Email: $company->email", 0, 1, "C");
		
		$pdf->Line(10, 33, 90, 33);
		$pdf->Ln(1);

		$pdf->SetFont("Arial", "BI", 10);
		$pdf->Cell(20, 5, "Bill to:", 0, 0, "");

		$pdf->SetFont("Courier", "BI", 10);
		$pdf->Cell(60, 5, "Barituer Jacob", 0, 1, "");

		$pdf->SetFont("Arial", "BI", 10);
		$pdf->Cell(20, 5, "Invoice no:", 0, 0, "");

		$pdf->SetFont("Courier", "BI", 10);
		$pdf->Cell(60, 5, "687", 0, 1, "");

		$pdf->SetFont("Arial", "BI", 10);
		$pdf->Cell(20, 5, "Date:", 0, 0, "");

		$pdf->SetFont("Courier", "BI", 10);
		$pdf->Cell(60, 5, "06-12-2023", 0, 1, "");


		$pdf->SetFont("Courier", "B", 10);
		$pdf->Cell(25, 5, "", 0, 0, "L");
		$pdf->Cell(25, 5, "SUBTOTAL", 1, 0, "C");
		$pdf->Cell(30, 5, "76800", 1, 1, "L");


		$pdf->Output();
	}

}
