<?php 
namespace App\Controllers;

use Tiyyick\Router\Controller;
use Tiyyick\Http\Request;

use App\Models\EmailTemplate;
use App\Models\EmailConfig;
use App\Models\SmsTemplate;
use App\Models\SmsConfig;
use App\Models\Role;

/**
 * 
 */
class CommunicationController extends Controller
{
	public function emailTemplate()
	{
		$emailTemplates = EmailTemplate::query()->order_by('id|DESC')->all();

		return render('admin/communication/email-template', ['email_templates' => $emailTemplates]);
	}

	public function createEmailTemplate(Request $request)
	{
		$valid = validate($request, [
			'subject' => ['required' => true],
			'message' => ['required' => true],
		]);

		if ($valid->isValid()) {
			EmailTemplate::query()->create($request->body()); 

		    return json_response(['ok' => true, 'msg' => "Email template created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function updateEmailTemplate(Request $request, $id)
	{
		$valid = validate($request, [
			'subject' => ['required' => true],
			'message' => ['required' => true],
		]);

		if ($valid->isValid()) {
			EmailTemplate::query()->filter(['id' => $id])->update($request->body()); 

		    return json_response(['ok' => true, 'msg' => "Email template updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deleteEmailTemplate(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			EmailTemplate::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Email template deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	// SMS TEMPLATE
	public function smsTemplate()
	{
		$smsTemplates = SmsTemplate::query()->order_by('id|DESC')->all();

		return render('admin/communication/sms-template', ['sms_templates' => $smsTemplates]);
	}

	public function createSmsTemplate(Request $request)
	{
		$valid = validate($request, [
			'title' => ['required' => true],
			'message' => ['required' => true], 
		]);

		if ($valid->isValid()) {
			SmsTemplate::query()->create($request->body());

		    return json_response(['ok' => true, 'msg' => "SMS template created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function updateSmsTemplate(Request $request, $id)
	{
		$valid = validate($request, [
			'title' => ['required' => true],
			'message' => ['required' => true], 
		]);

		if ($valid->isValid()) {
			SmsTemplate::query()->filter(['id' => $id])->update($request->body()); 

		    return json_response(['ok' => true, 'msg' => "SMS template updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deleteSmsTemplate(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			SmsTemplate::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "SMS template deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	// EMAIL CONFIG
	public function emailConfig()
	{
		$emailConfigs = EmailConfig::query()->order_by('id|DESC')->all();

		return render('admin/communication/email-config', ['email_configs' => $emailConfigs]);
	}

	public function createEmailConfig(Request $request)
	{
		$valid = validate($request, [
			'email' => ['required' => true],
			'encryption' => ['required' => true],
			'smtp_host' => ['required' => true],
			'smtp_user' => ['required' => true],
			'smtp_pass' => ['required' => true],
			'smtp_port' => ['required' => true],
		]);

		if ($valid->isValid()) {
			EmailConfig::query()->create($request->body()); 

		    return json_response(['ok' => true, 'msg' => "Email config created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function emailConfigEdit($id)
	{
		$data['email_config'] = EmailConfig::query()->get_or404($id);

		return render('admin/communication/email-config-edit', $data);
	}

	public function updateEmailConfig(Request $request, $id)
	{
		$valid = validate($request, [
			'email' => ['required' => true],
			'encryption' => ['required' => true],
			'smtp_host' => ['required' => true],
			'smtp_user' => ['required' => true],
			'smtp_pass' => ['required' => true],
			'smtp_port' => ['required' => true],
		]);

		if ($valid->isValid()) {
			EmailConfig::query()->filter(['id' => $id])->update($request->body()); 

		    return json_response([
		    	'ok' => true, 
		    	'url' => route('email_config.index'), 
		    	'msg' => "Email config updated successfully"
			]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deleteEmailConfig(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			EmailConfig::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Email config deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	// SMS CONFIG
	public function smsConfig()
	{
		$smsConfigs = SmsConfig::query()->order_by('id|DESC')->all();

		return render('admin/communication/sms-config', ['sms_configs' => $smsConfigs]);
	}

	public function createSmsConfig(Request $request)
	{
		$valid = validate($request, [
			'name' => ['required' => true],
			'type' => ['required' => true],
			'api_id' => ['required' => true],
			'auth_key' => ['required' => true],
			'sender_id' => ['required' => true],
		]);

		if ($valid->isValid()) {
			SmsConfig::query()->create($request->body());

		    return json_response(['ok' => true, 'msg' => "SMS config created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function smsConfigEdit($id)
	{
		$data['sms_config'] = SmsConfig::query()->get_or404($id);

		return render('admin/communication/sms-config-edit', $data);
	}

	public function updateSmsConfig(Request $request, $id)
	{
		$valid = validate($request, [
			'name' => ['required' => true],
			'type' => ['required' => true],
			'api_id' => ['required' => true],
			'auth_key' => ['required' => true],
			'sender_id' => ['required' => true], 
		]);

		if ($valid->isValid()) {
			SmsConfig::query()->filter(['id' => $id])->update($request->body()); 

		    return json_response([
		    	'ok' => true, 
		    	'url' => route('sms_config.index'), 
		    	'msg' => "SMS config updated successfully"
			]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deleteSmsConfig(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			SmsConfig::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "SMS config deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function emailSendForm()
	{
		$data['roles'] = Role::query()->order_by('id|DESC')->all();
		$data['email_templates'] = EmailTemplate::query()->order_by('id|DESC')->all();

		return render('admin/communication/email-send', $data);
	}

	public function emailSend(Request $request)
	{
		filelog($request->body());

		return json_response(['ok' => true, 'msg' => "SMS config deleted successfully"]);
	}

}
