<?php 
namespace App\Controllers;

use Tiyyick\Router\Controller;
use Tiyyick\Http\Request;

use Mpdf\Mpdf;
use Dompdf\Dompdf;
use Spipu\Html2Pdf\Html2Pdf;

use App\Models\Staff;
use App\Models\IncomeHead;
use App\Models\ExpenseHead;
use App\Models\Income;
use App\Models\Expense;
use App\Models\PaymentMode;

/**
 * Income and Expense
 */
class AccountingController extends Controller
{
	/**
	 * GENERAL ACCOUNTING
	 * InEx meaning Income Expense
	 */
	public function incomeHead(Request $request)
	{
		if ($request->hasParam('_id')) {
			return json_response(['row' => IncomeHead::query()->get($request->_id)]);
		}

		$income_heads = IncomeHead::query()->order_by('id|DESC')->all();

		return render('admin/accounting/inex-head', ['income_heads' => $income_heads]);
	}

	public function expenseHead(Request $request)
	{
		if ($request->hasParam('_id')) {
			return json_response(['row' => ExpenseHead::query()->get($request->_id)]);
		}

		$expense_heads = ExpenseHead::query()->order_by('id|DESC')->all();

		return render('admin/accounting/inex-head', ['expense_heads' => $expense_heads]);
	}

	public function createIncomeHead(Request $request)
	{
		$valid = validate($request, [
			'name' => ['required' => true],
			'type' => ['required' => true],
		]);

		if ($valid->isValid()) {
			if ($request->hasParam('_id')) {
				IncomeHead::query()->filter(['id' => $request->_id])->update($request->body()); 

		    	return json_response(['ok' => true, 'msg' => "Income Head updated successfully"]);
			}

			IncomeHead::query()->create($request->body());

		    return json_response(['ok' => true, 'msg' => "Income Head created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function updateIncomeHead(Request $request, $id)
	{
		$valid = validate($request, [
			'name' => ['required' => true],
			'type' => ['required' => true],
		]);

		if ($valid->isValid()) {
			IncomeHead::query()->filter(['id' => $id])->update($request->body()); 

		    return json_response(['ok' => true, 'msg' => "Income Head updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deleteIncomeHead(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			IncomeHead::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Income Head deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	// Expense Head
	public function createExpenseHead(Request $request)
	{
		$valid = validate($request, [
			'name' => ['required' => true],
			'type' => ['required' => true],
		]);

		if ($valid->isValid()) {
			if ($request->hasParam('_id')) {
				ExpenseHead::query()->filter(['id' => $request->_id])->update($request->body()); 

		    	return json_response(['ok' => true, 'msg' => "Expense Head updated successfully"]);
			}

			ExpenseHead::query()->create($request->body());

		    return json_response(['ok' => true, 'msg' => "Expense Head created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function updateExpenseHead(Request $request, $id)
	{
		$valid = validate($request, [
			'name' => ['required' => true],
			'type' => ['required' => true],
		]);

		if ($valid->isValid()) {
			ExpenseHead::query()->filter(['id' => $id])->update($request->body()); 

		    return json_response(['ok' => true, 'msg' => "Expense Head updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deleteExpenseHead(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			ExpenseHead::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Expense Head deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	// INCOME
	public function income()
	{
		$incomes = Income::query()->order_by('id|DESC')->all();
		$heads = IncomeHead::query()->filter(['type' => 'income'])->all();

		return render('admin/accounting/income', ['incomes' => $incomes, 'heads' => $heads]);
	}

	public function selectIncome(Request $request)
	{
		$head = IncomeHead::query()->get($request->income_id);

		return json_response(prettify($head->incomes->all()));
	}

	public function createIncome(Request $request)
	{
		$valid = validate($request, [
			'title' => ['required' => true],
			'head' => ['required' => true],
			'amount' => ['required' => true],
		]);

		if ($valid->isValid()) {
			$income = new Income($request->body());

			if ($request->hasFile('attachment')) {
				$file = $request->getFile('attachment');
				$income->attachment = $file->store('income', bin2hex(random_bytes(10)) . '.jpg');
			}

			$income->save();

		    return json_response(['ok' => true, 'msg' => "Income created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function incomeEdit($id)
	{
		$income = Income::query()->get($id);
		$heads = IncomeHead::query()->filter(['type' => 'income'])->all();

		return render('admin/accounting/income-edit', ['income' => $income, 'heads' => $heads]);
	}

	public function updateIncome(Request $request, $id)
	{
		$valid = validate($request, [
			'title' => ['required' => true],
			'head' => ['required' => true],
			'amount' => ['required' => true],
		]);

		if ($valid->isValid()) {
			$income = Income::query()->filter(['id' => $id])->one(); 
			$income->update($request->body());

			if ($request->hasFile('attachment')) {
				if (file_exists(storage_path("income/$income->attachment"))) {
	                unlink(storage_path("income/$income->attachment"));
	            } 
				
				$file = $request->getFile('attachment');
				$income->attachment = $file->store('income',  bin2hex(random_bytes(10)). '.jpg');
			}

			$income->save();

		    return json_response(['ok' => true, 'url' => route('income.index'), 'msg' => "Income updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deleteIncome(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			Income::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Income deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	// EXPENSE
	public function expense()
	{
		$expenses = Expense::query()->order_by('id|DESC')->all();
		$heads = ExpenseHead::query()->filter(['type' => 'expense'])->all();

		return render('admin/accounting/expense', ['expenses' => $expenses, 'heads' => $heads]);
	}

	public function selectExpense(Request $request)
	{
		$head = ExpenseHead::query()->get($request->expense_id);

		return json_response(prettify($head->expenses->all()));
	}

	public function createExpense(Request $request)
	{
		$valid = validate($request, [
			'title' => ['required' => true],
			'head' => ['required' => true],
			'amount' => ['required' => true],
		]);

		if ($valid->isValid()) {
			$expense = new Expense($request->body());

			if ($request->hasFile('attachment')) {
				$file = $request->getFile('attachment');
				$expense->attachment = $file->store('expense', bin2hex(random_bytes(10)) . '.jpg');
			}

			$expense->save();

		    return json_response(['ok' => true, 'msg' => "Expense created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function expenseEdit($id)
	{
		$expense = Expense::query()->get($id);
		$heads = ExpenseHead::query()->filter(['type' => 'expense'])->all();

		return render('admin/accounting/expense-edit', ['expense' => $expense, 'heads' => $heads]);
	}

	public function updateExpense(Request $request, $id)
	{
		$valid = validate($request, [
			'title' => ['required' => true],
			'head' => ['required' => true],
			'amount' => ['required' => true],
		]);

		if ($valid->isValid()) {
			$expense = Expense::query()->filter(['id' => $id])->one(); 
			$expense->update($request->body());

			if ($request->hasFile('attachment')) {
				if (file_exists(storage_path("expense/$expense->attachment"))) {
	                unlink(storage_path("expense/$expense->attachment"));
	            } 
				
				$file = $request->getFile('attachment');
				$expense->attachment = $file->store('expense',  bin2hex(random_bytes(10)). '.jpg');
			}

			$expense->save();

		    return json_response(['ok' => true, 'url' => route('expense.index'), 'msg' => "Expense updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deleteExpense(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			Expense::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Expense deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

}
