<?php 
namespace App\Config;

use App\Middlewares\ForbiddenMiddleware;
use App\Middlewares\AuthMiddleware;
use App\Middlewares\LoggedinMiddleware;
// use App\Models\User;
use App\Models\Staff;

/**
 * 
 */
class Service
{
	public static $middlewares = [
		'forbidden' => ForbiddenMiddleware::class,
		'auth_required' => AuthMiddleware::class,
		'loggedin' => LoggedinMiddleware::class,
	];

	public static $dependencies = [
		// 'db' => DBContext::class,
		'validation' => Validation::class,
	];
	
	public static $authModels = [
		Staff::class,
		// User::class,
	];

	public static $loginPath = '/user/login';
	
	public static $colorCodes = array(
		'#3498db',
		'#23B7E5',
		'#2ecc71',
		'#F39C12',
		'#e74c3c',
		'#bdc3c7',
		'#7f8c8d',
		'#7E57C2',
		'#1abc9c',
		'#f1c40f',
		'#E91E63',
		'#7f8c8d',
	);
}
