<?php 
namespace App\Config;

use Tiyyick\Router\Container;
use Tiyyick\Router\Route;
use Tiyyick\Qorm\SetUp;
use Tiyyick\Auth\Auth;
use Tiyyick\Utils\App;
use Tiyyick\Files\Storage;
use Tiyyick\Files\CharAvatar;

/**
 * 
 */
class Bootstrap  
{

	function __construct()
	{
		$this->debugSetting(); // Pass in $_ENV['debug'] as argument
		SetUp::main();
		Container::registerDependencies(Service::$dependencies);
		Container::registerMiddlewares(Service::$middlewares); 
		Auth::registerAuthModels(Service::$authModels);
		Auth::setLoginPath(Service::$loginPath);
		App::auth()->loginUserFromCookie();
		require_once 'Constants.php';
		require_once URL_DIR . 'url.php';
		CharAvatar::setColorCodes(Service::$colorCodes);
		CharAvatar::setFont(public_path('font/monofont.ttf'));
	}

	public static function init()
	{
		new static();
		return App::route();
	}

	public function debugSetting($debug = true)
	{
		if ($debug) {
			ini_set("display_errors", 1);
		} else {
			ini_set("display_errors", 0);
		}
	}

}
